
	
// Filter Cartoon
__kernel void filter_Cartoon(__read_only image2d_t merge,   	// image merge
						     __global uchar* table,   			// input buffer table
							 __global uchar* palette,   		// input buffer tableR
							 __write_only image2d_t retImage,   // image result	
						     __private int paLineBytes,
						     __private int alpha)	 			// blend factor, scrope[0-100]	
{
	int w = get_global_id(0);
	int h = get_global_id(1);
	int width = get_image_width(merge);
	int height = get_image_height(merge);

	if(w >= width || h >= height)
			return;
	const sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;
	

	float4 color = read_imagef(merge, sampler, (int2)(w, h));
	uchar sr = color.x * 255;
	uchar sg = color.y * 255;
	uchar sb = color.z * 255;
	
	int i = (sr >> 3 << 10) + (sg >> 3 << 5) + (sb >> 3);
	i = table[i];
	int paletteOffset = i * paLineBytes;
	
	float factor = (float)(alpha)/100.0f;
	
	uchar ret_b = (uchar)(palette[paletteOffset + 2] * factor + (1.0f - factor) * sb);
	uchar ret_g = (uchar)(palette[paletteOffset + 1] * factor + (1.0f - factor) * sg);
	uchar ret_r = (uchar)(palette[paletteOffset + 0] * factor + (1.0f - factor) * sr);
	
	float4 retColor = (float4)((ret_r) / 255.0f, (ret_g) / 255.0f, (ret_b) / 255.0f, color.w);
	
	write_imagef(retImage, (int2)(w, h), retColor);
}

// Filter Charcoal
#define MAKE_GREY(b, g, r) ((29 * (b) + 150 * (g) + 76 * (r) + 255) >> 8)

__kernel void filter_Charcoal(__read_only image2d_t image,   		// image image
							  __read_only image2d_t merge,   		// image merge
							  __global uchar* table,   				// input buffer table
							  __write_only image2d_t retImage,   	// image result	
						      __private int alpha)	 				// blend factor, scrope[0-100]	
{
	int w = get_global_id(0);
	int h = get_global_id(1);
	int width = get_image_width(image);
	int height = get_image_height(image);

	if(w >= width || h >= height)
			return;
	const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;

	float2 uv = (float2)((float)(w) / width, (float)(h) / height);
	float4 color = read_imagef(image, sampler, uv);
	uchar sr = color.x * 255;
	uchar sg = color.y * 255;
	uchar sb = color.z * 255;
	
	float4 colorM = read_imagef(merge, sampler, uv);
	uchar mr = colorM.x * 255;
	uchar mg = colorM.y * 255;
	uchar mb = colorM.z * 255;
	int gray = MAKE_GREY(sb, sg, sr);
	float factor = (float)(alpha)/100.0f;
	
	uchar ret_b = (uchar)(table[mb + gray] * factor + (1.0f - factor) * sb);
	uchar ret_g = (uchar)(table[mg + gray] * factor + (1.0f - factor) * sg);
	uchar ret_r = (uchar)(table[mr + gray] * factor + (1.0f - factor) * sr);
	
	float4 retColor = (float4)((ret_r) / 255.0f, (ret_g) / 255.0f, (ret_b) / 255.0f, color.w);
	
	write_imagef(retImage, (int2)(w, h), retColor);

}

// Filter FilmGrain
#define amount (0.25f)
float rand(float2 n)
{
	float m = sin(dot(n, (float2)(12.9898f, 78.233f))) * 43758.5453f;
	float i;
	return fract(m, &i);
}

__kernel void filter_FilmGrain(__read_only image2d_t image,   		// image image
							   __write_only image2d_t retImage,   	// image result
							   __private int percent,				// scrope[0-100]
						       __private int alpha)	 				// blend factor, scrope[0-100]	
{
	int w = get_global_id(0);
	int h = get_global_id(1);
	int width = get_image_width(image);
	int height = get_image_height(image);

	if(w >= width || h >= height)
			return;
	const sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;
	

	float4 color = read_imagef(image, sampler, (int2)(w, h));
	float a = color.w;
	
	float sizeRattio = (float)(percent) / 100;
	float2 uv = (float2)((float)(w) / width, (float)(h) / height);
	float val = amount * sizeRattio * (1.9f * rand(uv) - 1.0f);
	float factor = (float)(alpha)/100.0f;
	
	color += val * factor;
	
	float4 retColor = (float4)(color.xyz, a);
	
	write_imagef(retImage, (int2)(w, h), retColor);
}